<?xml version="1.0" encoding="UTF-8" standalone="yes"?>
<xsl:stylesheet xmlns:xsd="http://www.w3.org/2001/XMLSchema"
                xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
                xmlns:saxon="http://saxon.sf.net/"
                xmlns:xs="http://www.w3.org/2001/XMLSchema"
                xmlns:schold="http://www.ascc.net/xml/schematron"
                xmlns:iso="http://purl.oclc.org/dsdl/schematron"
                xmlns:xhtml="http://www.w3.org/1999/xhtml"
                xmlns:hl7="urn:hl7-org:v3"
                xmlns:xsi="http://www.w3.org/2001/XMLSchema-instance"
                xmlns:ao="http://www.aortarelease.nl/805/"
                xmlns:soap="http://schemas.xmlsoap.org/soap/envelope/"
                xmlns:wsse="http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-wssecurity-secext-1.0.xsd"
                xmlns:saml="urn:oasis:names:tc:SAML:2.0:assertion"
                xmlns:xmlds="http://www.w3.org/2000/09/xmldsig#"
                version="2.0"><!--Implementers: please note that overriding process-prolog or process-root is 
    the preferred method for meta-stylesheets to use where possible. -->
<xsl:param name="archiveDirParameter"/>
   <xsl:param name="archiveNameParameter"/>
   <xsl:param name="fileNameParameter"/>
   <xsl:param name="fileDirParameter"/>
   <xsl:variable name="document-uri">
      <xsl:value-of select="document-uri(/)"/>
   </xsl:variable>

   <!--PHASES-->


<!--PROLOG-->
<xsl:output method="text"/>

   <!--XSD TYPES FOR XSLT2-->


<!--KEYS AND FUNCTIONS-->


<!--DEFAULT RULES-->


<!--MODE: SCHEMATRON-SELECT-FULL-PATH-->
<!--This mode can be used to generate an ugly though full XPath for locators-->
<xsl:template match="*" mode="schematron-select-full-path">
      <xsl:apply-templates select="." mode="schematron-get-full-path"/>
   </xsl:template>

   <!--MODE: SCHEMATRON-FULL-PATH-->
<!--This mode can be used to generate an ugly though full XPath for locators-->
<xsl:template match="*" mode="schematron-get-full-path">
      <xsl:apply-templates select="parent::*" mode="schematron-get-full-path"/>
      <xsl:text>/</xsl:text>
      <xsl:choose>
         <xsl:when test="namespace-uri()=''">
            <xsl:value-of select="name()"/>
         </xsl:when>
         <xsl:otherwise>
            <xsl:text>*:</xsl:text>
            <xsl:value-of select="local-name()"/>
            <xsl:text>[namespace-uri()='</xsl:text>
            <xsl:value-of select="namespace-uri()"/>
            <xsl:text>']</xsl:text>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:variable name="preceding"
                    select="count(preceding-sibling::*[local-name()=local-name(current())                                   and namespace-uri() = namespace-uri(current())])"/>
      <xsl:text>[</xsl:text>
      <xsl:value-of select="1+ $preceding"/>
      <xsl:text>]</xsl:text>
   </xsl:template>
   <xsl:template match="@*" mode="schematron-get-full-path">
      <xsl:apply-templates select="parent::*" mode="schematron-get-full-path"/>
      <xsl:text>/</xsl:text>
      <xsl:choose>
         <xsl:when test="namespace-uri()=''">@<xsl:value-of select="name()"/>
         </xsl:when>
         <xsl:otherwise>
            <xsl:text>@*[local-name()='</xsl:text>
            <xsl:value-of select="local-name()"/>
            <xsl:text>' and namespace-uri()='</xsl:text>
            <xsl:value-of select="namespace-uri()"/>
            <xsl:text>']</xsl:text>
         </xsl:otherwise>
      </xsl:choose>
   </xsl:template>

   <!--MODE: SCHEMATRON-FULL-PATH-2-->
<!--This mode can be used to generate prefixed XPath for humans-->
<xsl:template match="node() | @*" mode="schematron-get-full-path-2">
      <xsl:for-each select="ancestor-or-self::*">
         <xsl:text>/</xsl:text>
         <xsl:value-of select="name(.)"/>
         <xsl:if test="preceding-sibling::*[name(.)=name(current())]">
            <xsl:text>[</xsl:text>
            <xsl:value-of select="count(preceding-sibling::*[name(.)=name(current())])+1"/>
            <xsl:text>]</xsl:text>
         </xsl:if>
      </xsl:for-each>
      <xsl:if test="not(self::*)">
         <xsl:text/>/@<xsl:value-of select="name(.)"/>
      </xsl:if>
   </xsl:template>
   <!--MODE: SCHEMATRON-FULL-PATH-3-->
<!--This mode can be used to generate prefixed XPath for humans 
	(Top-level element has index)-->
<xsl:template match="node() | @*" mode="schematron-get-full-path-3">
      <xsl:for-each select="ancestor-or-self::*">
         <xsl:text>/</xsl:text>
         <xsl:value-of select="name(.)"/>
         <xsl:if test="parent::*">
            <xsl:text>[</xsl:text>
            <xsl:value-of select="count(preceding-sibling::*[name(.)=name(current())])+1"/>
            <xsl:text>]</xsl:text>
         </xsl:if>
      </xsl:for-each>
      <xsl:if test="not(self::*)">
         <xsl:text/>/@<xsl:value-of select="name(.)"/>
      </xsl:if>
   </xsl:template>

   <!--MODE: GENERATE-ID-FROM-PATH -->
<xsl:template match="/" mode="generate-id-from-path"/>
   <xsl:template match="text()" mode="generate-id-from-path">
      <xsl:apply-templates select="parent::*" mode="generate-id-from-path"/>
      <xsl:value-of select="concat('.text-', 1+count(preceding-sibling::text()), '-')"/>
   </xsl:template>
   <xsl:template match="comment()" mode="generate-id-from-path">
      <xsl:apply-templates select="parent::*" mode="generate-id-from-path"/>
      <xsl:value-of select="concat('.comment-', 1+count(preceding-sibling::comment()), '-')"/>
   </xsl:template>
   <xsl:template match="processing-instruction()" mode="generate-id-from-path">
      <xsl:apply-templates select="parent::*" mode="generate-id-from-path"/>
      <xsl:value-of select="concat('.processing-instruction-', 1+count(preceding-sibling::processing-instruction()), '-')"/>
   </xsl:template>
   <xsl:template match="@*" mode="generate-id-from-path">
      <xsl:apply-templates select="parent::*" mode="generate-id-from-path"/>
      <xsl:value-of select="concat('.@', name())"/>
   </xsl:template>
   <xsl:template match="*" mode="generate-id-from-path" priority="-0.5">
      <xsl:apply-templates select="parent::*" mode="generate-id-from-path"/>
      <xsl:text>.</xsl:text>
      <xsl:value-of select="concat('.',name(),'-',1+count(preceding-sibling::*[name()=name(current())]),'-')"/>
   </xsl:template>

   <!--MODE: GENERATE-ID-2 -->
<xsl:template match="/" mode="generate-id-2">U</xsl:template>
   <xsl:template match="*" mode="generate-id-2" priority="2">
      <xsl:text>U</xsl:text>
      <xsl:number level="multiple" count="*"/>
   </xsl:template>
   <xsl:template match="node()" mode="generate-id-2">
      <xsl:text>U.</xsl:text>
      <xsl:number level="multiple" count="*"/>
      <xsl:text>n</xsl:text>
      <xsl:number count="node()"/>
   </xsl:template>
   <xsl:template match="@*" mode="generate-id-2">
      <xsl:text>U.</xsl:text>
      <xsl:number level="multiple" count="*"/>
      <xsl:text>_</xsl:text>
      <xsl:value-of select="string-length(local-name(.))"/>
      <xsl:text>_</xsl:text>
      <xsl:value-of select="translate(name(),':','.')"/>
   </xsl:template>
   <!--Strip characters--><xsl:template match="text()" priority="-1"/>

   <!--SCHEMA SETUP-->
<xsl:template match="/">
      <xsl:apply-templates select="/" mode="M8"/>
      <xsl:apply-templates select="/" mode="M9"/>
      <xsl:apply-templates select="/" mode="M10"/>
      <xsl:apply-templates select="/" mode="M11"/>
      <xsl:apply-templates select="/" mode="M12"/>
      <xsl:apply-templates select="/" mode="M13"/>
      <xsl:apply-templates select="/" mode="M14"/>
      <xsl:apply-templates select="/" mode="M15"/>
      <xsl:apply-templates select="/" mode="M16"/>
   </xsl:template>

   <!--SCHEMATRON PATTERNS-->


<!--PATTERN SAML Assertion-->


	<!--RULE -->
<xsl:template match="/soap:Envelope/soap:Header[1]/wsse:Security[1]/saml:Assertion"
                 priority="1000"
                 mode="M8">
      <xsl:variable name="samlId"
                    select="concat('token_',//hl7:*[hl7:interactionId][1]/hl7:id/@root,'_',//hl7:*[hl7:interactionId][1]/hl7:id/@extension)"/>

		    <!--ASSERT error-->
<xsl:choose>
         <xsl:when test="@Version='2.0'"/>
         <xsl:otherwise>
            <xsl:message>@Version moet aanwezig en de waarde '2.0' hebben (@Version='2.0' / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/>)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--REPORT warning-->
<xsl:if test="not(@ID=$samlId)">
         <xsl:message>@ID is niet opgebouwd volgens de aanbevolen methode 'token_messageIdRoot_messageIdExtension', verwacht '<xsl:text/>
            <xsl:value-of select="$samlId"/>
            <xsl:text/>' (not(@ID=$samlId) / warning / <xsl:apply-templates select="." mode="schematron-select-full-path"/>)</xsl:message>
      </xsl:if>

		    <!--ASSERT error-->
<xsl:choose>
         <xsl:when test="saml:Issuer"/>
         <xsl:otherwise>
            <xsl:message>Issuer is verplicht (saml:Issuer / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/>)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
<xsl:choose>
         <xsl:when test="xmlds:Signature"/>
         <xsl:otherwise>
            <xsl:message>Signature in de namespace 'http://www.w3.org/2000/09/xmldsig#' is verplicht (xmlds:Signature / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/>)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
<xsl:choose>
         <xsl:when test="saml:Subject"/>
         <xsl:otherwise>
            <xsl:message>Subject is verplicht (saml:Subject / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/>)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
<xsl:choose>
         <xsl:when test="saml:Conditions"/>
         <xsl:otherwise>
            <xsl:message>Conditions is verplicht (saml:Conditions / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/>)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
<xsl:choose>
         <xsl:when test="saml:AuthnStatement"/>
         <xsl:otherwise>
            <xsl:message>AuthnStatement is verplicht (saml:AuthnStatement / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/>)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
<xsl:choose>
         <xsl:when test="saml:AttributeStatement"/>
         <xsl:otherwise>
            <xsl:message>AttributeStatement is verplicht (saml:AttributeStatement / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/>)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*|comment()|processing-instruction()" mode="M8"/>
   </xsl:template>
   <xsl:template match="text()" priority="-1" mode="M8"/>
   <xsl:template match="@*|node()" priority="-2" mode="M8">
      <xsl:apply-templates select="*|comment()|processing-instruction()" mode="M8"/>
   </xsl:template>

   <!--PATTERN SAML Signature-->


	<!--RULE -->
<xsl:template match="/soap:Envelope/soap:Header[1]/wsse:Security[1]/saml:Assertion/xmlds:Signature"
                 priority="1000"
                 mode="M9">

		<!--ASSERT error-->
<xsl:choose>
         <xsl:when test="xmlds:KeyInfo"/>
         <xsl:otherwise>
            <xsl:message>Signature/KeyInfo is verplicht (xmlds:KeyInfo / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/>)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*|comment()|processing-instruction()" mode="M9"/>
   </xsl:template>
   <xsl:template match="text()" priority="-1" mode="M9"/>
   <xsl:template match="@*|node()" priority="-2" mode="M9">
      <xsl:apply-templates select="*|comment()|processing-instruction()" mode="M9"/>
   </xsl:template>

   <!--PATTERN SAML Signature/Reference-->


	<!--RULE -->
<xsl:template match="/soap:Envelope/soap:Header[1]/wsse:Security[1]/saml:Assertion/xmlds:Signature/xmlds:SignedInfo/xmlds:Reference"
                 priority="1000"
                 mode="M10">

		<!--ASSERT error-->
<xsl:choose>
         <xsl:when test="@URI=concat('#',/soap:Envelope/soap:Header[1]/wsse:Security[1]/saml:Assertion/@ID)"/>
         <xsl:otherwise>
            <xsl:message>Signature/SignedInfo/Reference/@URI moet verwijzen naar Assertion/@ID (@URI=concat('#',/soap:Envelope/soap:Header[1]/wsse:Security[1]/saml:Assertion/@ID) / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/>)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*|comment()|processing-instruction()" mode="M10"/>
   </xsl:template>
   <xsl:template match="text()" priority="-1" mode="M10"/>
   <xsl:template match="@*|node()" priority="-2" mode="M10">
      <xsl:apply-templates select="*|comment()|processing-instruction()" mode="M10"/>
   </xsl:template>

   <!--PATTERN SAML Signature/Reference/Transforms-->


	<!--RULE -->
<xsl:template match="/soap:Envelope/soap:Header[1]/wsse:Security[1]/saml:Assertion/xmlds:Signature/xmlds:SignedInfo/xmlds:Reference/xmlds:Transforms"
                 priority="1000"
                 mode="M11">

		<!--ASSERT error-->
<xsl:choose>
         <xsl:when test="xmlds:Transform[@Algorithm='http://www.w3.org/2000/09/xmldsig#enveloped-signature']"/>
         <xsl:otherwise>
            <xsl:message>Signature/SignedInfo/Reference/Transforms/Transform/@Algorithm='http://www.w3.org/2000/09/xmldsig#enveloped-signature' is verplicht (xmlds:Transform[@Algorithm='http://www.w3.org/2000/09/xmldsig#enveloped-signature'] / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/>)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
<xsl:choose>
         <xsl:when test="xmlds:Transform[@Algorithm='http://www.w3.org/2001/10/xml-exc-c14n#']"/>
         <xsl:otherwise>
            <xsl:message>Signature/SignedInfo/Reference/Transforms/Transform/@Algorithm='http://www.w3.org/2001/10/xml-exc-c14n#' is verplicht (xmlds:Transform[@Algorithm='http://www.w3.org/2001/10/xml-exc-c14n#'] / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/>)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*|comment()|processing-instruction()" mode="M11"/>
   </xsl:template>
   <xsl:template match="text()" priority="-1" mode="M11"/>
   <xsl:template match="@*|node()" priority="-2" mode="M11">
      <xsl:apply-templates select="*|comment()|processing-instruction()" mode="M11"/>
   </xsl:template>

   <!--PATTERN SAML Subject-->


	<!--RULE -->
<xsl:template match="/soap:Envelope/soap:Header[1]/wsse:Security[1]/saml:Assertion/saml:Subject"
                 priority="1000"
                 mode="M12">

		<!--ASSERT error-->
<xsl:choose>
         <xsl:when test="starts-with(saml:NameID/text(),'urn:cert:')"/>
         <xsl:otherwise>
            <xsl:message>NameID moet beginnen met 'urn:cert:' en worden gevolgd door het seriennummer certifcaat (starts-with(saml:NameID/text(),'urn:cert:') / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/>)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*|comment()|processing-instruction()" mode="M12"/>
   </xsl:template>
   <xsl:template match="text()" priority="-1" mode="M12"/>
   <xsl:template match="@*|node()" priority="-2" mode="M12">
      <xsl:apply-templates select="*|comment()|processing-instruction()" mode="M12"/>
   </xsl:template>

   <!--PATTERN SAML Conditions-->


	<!--RULE -->
<xsl:template match="/soap:Envelope/soap:Header[1]/wsse:Security[1]/saml:Assertion/saml:Conditions"
                 priority="1000"
                 mode="M13">
      <xsl:variable name="notBefore"
                    select="xs:integer(format-dateTime(xs:dateTime(@NotBefore), '[Y0001][M01][D01][H01][m01][s01]', 'en', (), ()))"/>
      <xsl:variable name="notOnOrAfter"
                    select="xs:integer(format-dateTime(xs:dateTime(@NotOnOrAfter), '[Y0001][M01][D01][H01][m01][s01]', 'en', (), ()))"/>

		    <!--ASSERT error-->
<xsl:choose>
         <xsl:when test="$notOnOrAfter &gt; $notBefore"/>
         <xsl:otherwise>
            <xsl:message>Datum @NotBefore moet voor @NotOnOrAfter liggen ($notOnOrAfter &gt; $notBefore / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/>)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
<xsl:choose>
         <xsl:when test="saml:AudienceRestriction"/>
         <xsl:otherwise>
            <xsl:message>AudienceRestriction is verplicht (saml:AudienceRestriction / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/>)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*|comment()|processing-instruction()" mode="M13"/>
   </xsl:template>
   <xsl:template match="text()" priority="-1" mode="M13"/>
   <xsl:template match="@*|node()" priority="-2" mode="M13">
      <xsl:apply-templates select="*|comment()|processing-instruction()" mode="M13"/>
   </xsl:template>

   <!--PATTERN SAML Conditions/AudienceRestrictions/Audience-->
<xsl:variable name="messageReceiver"
                 select="concat('urn:IIroot:',//hl7:receiver[1]/hl7:device/hl7:id/@root,':IIext:',//hl7:receiver[1]/hl7:device/hl7:id/@extension)"/>

	  <!--RULE -->
<xsl:template match="/soap:Envelope/soap:Header[1]/wsse:Security[1]/saml:Assertion/saml:Conditions[1]/saml:AudienceRestriction[1]/saml:Audience"
                 priority="1000"
                 mode="M14">

		<!--ASSERT error-->
<xsl:choose>
         <xsl:when test="text() = $messageReceiver"/>
         <xsl:otherwise>
            <xsl:message>Audience '<xsl:text/>
               <xsl:value-of select="."/>
               <xsl:text/>' moet overeenkomen met waarde '<xsl:text/>
               <xsl:value-of select="$messageReceiver"/>
               <xsl:text/>' (text() = $messageReceiver / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/>)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*|comment()|processing-instruction()" mode="M14"/>
   </xsl:template>
   <xsl:template match="text()" priority="-1" mode="M14"/>
   <xsl:template match="@*|node()" priority="-2" mode="M14">
      <xsl:apply-templates select="*|comment()|processing-instruction()" mode="M14"/>
   </xsl:template>

   <!--PATTERN SAML AuthnStatement/AuthnContextClassRef-->


	<!--RULE -->
<xsl:template match="/soap:Envelope/soap:Header[1]/wsse:Security[1]/saml:Assertion/saml:AuthnStatement/saml:AuthnContext/saml:AuthnContextClassRef"
                 priority="1000"
                 mode="M15">

		<!--ASSERT error-->
<xsl:choose>
         <xsl:when test=".='urn:oasis:names:tc:SAML:2.0:ac:classes:SmartcardPKI'"/>
         <xsl:otherwise>
            <xsl:message>Waarde moet 'urn:oasis:names:tc:SAML:2.0:ac:classes:SmartcardPKI' zijn (.='urn:oasis:names:tc:SAML:2.0:ac:classes:SmartcardPKI' / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/>)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*|comment()|processing-instruction()" mode="M15"/>
   </xsl:template>
   <xsl:template match="text()" priority="-1" mode="M15"/>
   <xsl:template match="@*|node()" priority="-2" mode="M15">
      <xsl:apply-templates select="*|comment()|processing-instruction()" mode="M15"/>
   </xsl:template>

   <!--PATTERN SAML AttributeStatement SAML AttributeStatement/Attribute (burgerServiceNummer) SAML AttributeStatement/Attribute (triggerEventId) SAML AttributeStatement/Attribute (messageIdExt) SAML AttributeStatement/Attribute (messageIdRoot)-->


	<!--RULE -->
<xsl:template match="/soap:Envelope/soap:Header[1]/wsse:Security[1]/saml:Assertion/saml:AttributeStatement[1]"
                 priority="1008"
                 mode="M16">

		<!--ASSERT error-->
<xsl:choose>
         <xsl:when test="saml:Attribute[@Name='burgerServiceNummer']/saml:AttributeValue"/>
         <xsl:otherwise>
            <xsl:message>Attribute/@Name='burgerServiceNummer' moet zijn meegetekend (saml:Attribute[@Name='burgerServiceNummer']/saml:AttributeValue / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/>)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
<xsl:choose>
         <xsl:when test="saml:Attribute[@Name='triggerEventId']/saml:AttributeValue"/>
         <xsl:otherwise>
            <xsl:message>Attribute/@Name='triggerEventId' moet zijn meegetekend (saml:Attribute[@Name='triggerEventId']/saml:AttributeValue / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/>)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
<xsl:choose>
         <xsl:when test="saml:Attribute[@Name='messageIdExt']/saml:AttributeValue"/>
         <xsl:otherwise>
            <xsl:message>Attribute/@Name='messageIdExt' moet zijn meegetekend (saml:Attribute[@Name='messageIdExt']/saml:AttributeValue / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/>)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
<xsl:choose>
         <xsl:when test="saml:Attribute[@Name='messageIdRoot']/saml:AttributeValue"/>
         <xsl:otherwise>
            <xsl:message>Attribute/@Name='messageIdRoot' moet zijn meegetekend (saml:Attribute[@Name='messageIdRoot']/saml:AttributeValue / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/>)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*|comment()|processing-instruction()" mode="M16"/>
   </xsl:template>

	  <!--RULE -->
<xsl:template match="/soap:Envelope/soap:Header[1]/wsse:Security[1]/saml:Assertion/saml:AttributeStatement[1]/saml:Attribute[@Name='burgerServiceNummer']/saml:AttributeValue"
                 priority="1006"
                 mode="M16">
      <xsl:variable name="codeValue" select="text()"/>
      <xsl:variable name="patientId" select="//hl7:*[@root='2.16.840.1.113883.2.4.6.3']/@extension"/>

		    <!--ASSERT error-->
<xsl:choose>
         <xsl:when test=". = $patientId"/>
         <xsl:otherwise>
            <xsl:message>Attribute burgerServiceNummer '<xsl:text/>
               <xsl:value-of select="$codeValue"/>
               <xsl:text/>' moet overeenkomen met verwachte waarde 
                '<xsl:text/>
               <xsl:value-of select="$patientId"/>
               <xsl:text/>' (. = $patientId / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/>)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*|comment()|processing-instruction()" mode="M16"/>
   </xsl:template>

	  <!--RULE -->
<xsl:template match="/soap:Envelope/soap:Header[1]/wsse:Security[1]/saml:Assertion/saml:AttributeStatement[1]/saml:Attribute[@Name='triggerEventId']/saml:AttributeValue"
                 priority="1004"
                 mode="M16">
      <xsl:variable name="codeValue" select="text()"/>
      <xsl:variable name="interactionId" select="//hl7:interactionId[1]/@extension"/>
      <xsl:variable name="vocabFile"
                    select="concat('../vocab/',//hl7:interactionId[1]/@root,'.xml')"/>

		    <!--ASSERT error-->
<xsl:choose>
         <xsl:when test="document(concat('../vocab/',//hl7:interactionId[1]/@root,'.xml'))/*/hl7:code[@code=$interactionId]/hl7:reference[@extension=$codeValue]"/>
         <xsl:otherwise>
            <xsl:message>Attribute triggerEventId '<xsl:text/>
               <xsl:value-of select="$codeValue"/>
               <xsl:text/>' moet overeenkomen met verwachte waarde 
            '<xsl:text/>
               <xsl:value-of select="document(concat('../vocab/',//hl7:interactionId[1]/@root,'.xml'))/*/hl7:code[@code=$interactionId]/hl7:reference/@extension"/>
               <xsl:text/>' (document(concat('../vocab/',//hl7:interactionId[1]/@root,'.xml'))/*/hl7:code[@code=$interactionId]/hl7:reference[@extension=$codeValue] / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/>)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*|comment()|processing-instruction()" mode="M16"/>
   </xsl:template>

	  <!--RULE -->
<xsl:template match="/soap:Envelope/soap:Header[1]/wsse:Security[1]/saml:Assertion/saml:AttributeStatement[1]/saml:Attribute[@Name='messageIdExt']/saml:AttributeValue"
                 priority="1002"
                 mode="M16">
      <xsl:variable name="codeValue" select="text()"/>
      <xsl:variable name="messageIdExt" select="//hl7:*[hl7:interactionId][1]/hl7:id/@extension"/>

		    <!--ASSERT error-->
<xsl:choose>
         <xsl:when test="$codeValue = $messageIdExt"/>
         <xsl:otherwise>
            <xsl:message>Attribute messageIdExt '<xsl:text/>
               <xsl:value-of select="$codeValue"/>
               <xsl:text/>' moet overeenkomen met verwachte waarde '<xsl:text/>
               <xsl:value-of select="$messageIdExt"/>
               <xsl:text/>' ($codeValue = $messageIdExt / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/>)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*|comment()|processing-instruction()" mode="M16"/>
   </xsl:template>

	  <!--RULE -->
<xsl:template match="/soap:Envelope/soap:Header[1]/wsse:Security[1]/saml:Assertion/saml:AttributeStatement[1]/saml:Attribute[@Name='messageIdRoot']/saml:AttributeValue"
                 priority="1000"
                 mode="M16">
      <xsl:variable name="codeValue" select="text()"/>
      <xsl:variable name="messageIdRoot" select="//hl7:*[hl7:interactionId][1]/hl7:id/@root"/>

		    <!--ASSERT error-->
<xsl:choose>
         <xsl:when test="$codeValue = $messageIdRoot"/>
         <xsl:otherwise>
            <xsl:message>Attribute messageIdRoot '<xsl:text/>
               <xsl:value-of select="$codeValue"/>
               <xsl:text/>' moet overeenkomen met verwachte waarde '<xsl:text/>
               <xsl:value-of select="$messageIdRoot"/>
               <xsl:text/>' ($codeValue = $messageIdRoot / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/>)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*|comment()|processing-instruction()" mode="M16"/>
   </xsl:template>
   <xsl:template match="text()" priority="-1" mode="M16"/>
   <xsl:template match="@*|node()" priority="-2" mode="M16">
      <xsl:apply-templates select="*|comment()|processing-instruction()" mode="M16"/>
   </xsl:template>
</xsl:stylesheet>